<?xml version="1.0" encoding="UTF-8"?><!--
            Copyright
            2010 axYus - http://www.axyus.com
            2010 J.Leger - johann.leger@axyus.com

            This file is part of ODM print-comp.

            ODM print-comp is free software; you can redistribute it and/or modify
            it under the terms of the GNU Lesser General Public License as published by
            the Free Software Foundation; either version 2 of the License, or
            (at your option) any later version.

            ODM print-comp is distributed in the hope that it will be useful,
            but WITHOUT ANY WARRANTY; without even the implied warranty of
            MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
            GNU Lesser General Public License for more details.

            You should have received a copy of the GNU Lesser General Public License
            along with ODM print-comp; if not, write to the Free Software
            Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
        --><xsl:stylesheet xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:data="http://odm-budgetaire.org/data" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:date="http://exslt.org/dates-and-times" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:com="http://www.xemelios.org/namespaces#cg-1.0" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data"><xsl:import href="../../../../number.xsl"></xsl:import><xsl:import href="../../../../date.xsl"></xsl:import><xsl:import href="../../../../table.xsl"></xsl:import><xsl:import href="../../../../style.xsl"></xsl:import><xsl:import href="../../../../lien.xsl"></xsl:import><xsl:import href="../../../../commons/constants.xsl"></xsl:import><xsl:import href="../../../../commons/fonctions.xsl"></xsl:import><xsl:import href="../../../../commons/templates.xsl"></xsl:import><xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/ListeORMC"></xsl:variable><xsl:param name="nomenclaturePasEnrichie"></xsl:param><xsl:variable name="nomenclature" select="$nomenclaturePasEnrichie/n:Nomenclature"></xsl:variable><xsl:variable name="data" select="document('../../libelleAffiche.xml')/data"></xsl:variable><xsl:variable name="isPrint" select="1"></xsl:variable><xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="*"></xsl:template><xsl:template match="ListeORMC"><html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
   <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" /><meta name="generator" content="ODM" />
      
      <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css" />
      <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css" />
      
      <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:SimSun;
  panose-1:2 1 6 0 3 1 1 1 1 1;}
@font-face
  {font-family:Mangal;
  panose-1:0 0 4 0 0 0 0 0 0 0;}
@font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:"Liberation Serif";
  panose-1:2 2 6 3 5 4 5 2 3 4;}
@font-face
  {font-family:"\@SimSun";
  panose-1:2 1 6 0 3 1 1 1 1 1;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0cm;
  text-autospace:ideograph-other;
  font-size:12.0pt;
  font-family:"Liberation Serif",serif;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
@page{size:297mm 210mm;
  }
div.WordSection1
  {}
--&gt;
/**/
}</style></head>
   <body lang="FR"><div id="header">
         <div align="center">
            <xsl:variable name="varOdmTmpTab1"><table width="100%" class="MsoNormalTable " border="0" cellspacing="0" cellpadding="0"><tr><td width="50%" valign="top" style="padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1"><p style="line-height:115%;punctuation-wrap:simple;word-break: break-all"><span style="font-size:10.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                           <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Tresorerie/@Codique)"/>- 
                           
                           
                           <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Tresorerie/@LibellePoste)"/></span></p></td><td width="50%" valign="top" style="padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1"><p align="right" style="text-align:right;line-height:115%; punctuation-wrap:simple;word-break:break-all"><span style="font-size:10.0pt; line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Date édition :
                           
                           
                           <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/EnteteComptable/Infos/Edition/@DateEdition)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></p></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab1"></xsl:with-param></xsl:call-template>
         </div>
         <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
         <p class="MsoNormal"> </p>
      </div>
      
      <div class="WordSection1">
         <xsl:variable name="varOdmTmpTab2"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><thead>
               <tr><td width="100%" colspan="4" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1">
                     <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-family:&#34;Arial&#34;,sans-serif">Liste des ORMC</span></b></p>
                  </td></tr>
               <tr><td width="50%" colspan="2" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1"> </td><td width="50%" colspan="2" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1"> </td></tr>
               <xsl:choose><xsl:when test="$docbudg/Budget/@SIRET = $docbudg/EnteteComptable/Infos/Collectivite/@Siret"><xsl:variable name="varOdm1" select="$docbudg/Budget/ORMC"/><tr><td width="50%" colspan="2" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Collectivite/@CodeBC)"/> – <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Collectivite/@Libelle)"/></span></p></td><td width="50%" colspan="2" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Exercice  <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Exercice/@V)"/>:</span></p></td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="50%" colspan="2" valign="top" rowspan="1" style="padding:0cm 0cm 0cm 0cm"></td><td height="1px" width="50%" colspan="2" valign="top" rowspan="1" style="padding:0cm 0cm 0cm 0cm"></td></tr></xsl:otherwise></xsl:choose>
               <xsl:choose><xsl:when test="$docbudg/Budget/@SIRET = $docbudg/EnteteComptable/Infos/BudgetAnnexe/@Siret"><xsl:variable name="varOdm2" select="$docbudg/Budget/ORMC"/><tr><td width="50%" colspan="2" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/BudgetAnnexe/@CodeBC)"/> – <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/BudgetAnnexe/@Libelle)"/></span></p></td><td width="50%" colspan="2" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Exercice  <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Exercice/@V)"/></span></p></td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="50%" colspan="2" valign="top" rowspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="50%" colspan="2" valign="top" rowspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td></tr></xsl:otherwise></xsl:choose>
               <xsl:choose><xsl:when test="$docbudg/EnteteComptable/Infos/Collectivite/@TypeBC = 'BA' or $docbudg/EnteteComptable/Infos/Collectivite/@TypeBC = 'BR'"><xsl:variable name="varOdm3" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:LigneBudget"/><tr><td width="50%" colspan="2" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Collectivite/@TypeBC)"/> BA de <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/BudgetRattachement/@Libelle)"/></span></p></td><td width="50%" colspan="2" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1"> </td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="50%" colspan="2" valign="top" rowspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="50%" colspan="2" valign="top" rowspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td></tr></xsl:otherwise></xsl:choose>
            </thead><xsl:variable name="varOdm4" select="$docbudg/Budget/ORMC"/><xsl:variable name="varOdm5"><xsl:for-each select="$varOdm4"><xsl:sort select="./@NumOrdre" data-type="number"/><xsl:variable name="ligne" select="."/><tr><xsl:variable name="content1"> </xsl:variable><xsl:variable name="className1" select="$ligne/@Format"/><xsl:variable name="className2">LIBELLE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className1, ' ', $className2)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">25%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content1" /></xsl:call-template><xsl:variable name="content2"><xsl:variable name ="Link1">FICORMC</xsl:variable><xsl:variable name ="Link2" select="$docbudg/EnteteComptable/Infos/Collectivite/@Siret"/><xsl:variable name ="Link3" select="$docbudg/EnteteComptable/Infos/Exercice/@V"/><xsl:variable name ="Link4">06</xsl:variable><xsl:variable name ="Link5" select="$ligne/@IdBord"/><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_1" select="concat('ORMC', ' ', 'N°', ' ', $ligne/@IdBord)" /><xsl:with-param name="Param_2" select="$Link1" /><xsl:with-param name="Param_3" select="$Link2" /><xsl:with-param name="Param_4" select="$Link3" /><xsl:with-param name="Param_5" select="$Link4" /><xsl:with-param name="Param_6" select="$Link5" /></xsl:call-template> émis le <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($ligne/@DteBordEmission)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></xsl:variable><xsl:variable name="className3" select="$ligne/@Format"/><xsl:variable name="className4">LIBELLE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className3, ' ', $className4)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">2</xsl:with-param><xsl:with-param name="width">50%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content2" /></xsl:call-template><xsl:variable name="content3"> </xsl:variable><xsl:variable name="className5" select="$ligne/@Format"/><xsl:variable name="className6">LIBELLE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className5, ' ', $className6)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">25%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content3" /></xsl:call-template></tr></xsl:for-each></xsl:variable><xsl:variable name="varOdm6"><xsl:choose><xsl:when test="count($varOdm5/*) = 0"><tr class=" #tech#"><td height="1px" width="50%" colspan="2" valign="top" rowspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="50%" colspan="2" valign="top" rowspan="1" style="padding:0cm 0cm 0cm 0cm"></td></tr></xsl:when><xsl:otherwise><xsl:sequence select="$varOdm5"></xsl:sequence></xsl:otherwise></xsl:choose></xsl:variable><xsl:call-template name="table:processRowStyled"><xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param><xsl:with-param name="rows" select="$varOdm6/xhtml:tr"></xsl:with-param></xsl:call-template></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab2"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"> </p>
      </div>
   </body><script type="text/javascript">
            function iframeLoadPage(href) {
            try {
            parent.loadPage(href);
            } catch(ex) {
            //si on n'arrive pas a acceder a la page parente
            document.location.href = href;
            }
            }
            function scrollToElementId(elementId) {
            document.getElementById(elementId).scrollIntoView();
            }
        </script>
</html></xsl:template></xsl:stylesheet>